function [Kx1,Kf1,G1,M1,L1,H1,Kx2,Kf2,G2,M2,L2,H2,Kx3,Kf3,G3,M3,L3,H3] = Observer_controller_design(A1,B1,F1,C1,A2,B2,F2,C2,A3,B3,F3,C3,H01,H02,H03)

[n,m] = size(B1);
q = m;
[p,~] = size(C1);
[~,h] = size(H01);  

% weights
Cx1 = eye(n);
Cx2 = Cx1;
Cx3 = Cx1;
Ce1 = eye(n+q);
Ce2 = Ce1;
Ce3 = Ce1;

                
%%%%%%%%%%%%%
% augmented sys
bar_C1 = [C1 zeros(p,q)];
bar_B1 = [B1; zeros(q, m)];
bar_A1 = [A1 F1; zeros(q,q+n)];
bar_D1 = [zeros(n,q); eye(q)];

bar_C2 = [C2 zeros(p,q)];
bar_B2 = [B2; zeros(q, m)];
bar_A2 = [A2 F2; zeros(q,q+n)];
bar_D2 = [zeros(n,q); eye(q)];

bar_C3 = [C3 zeros(p,q)];
bar_B3 = [B3; zeros(q, m)];
bar_A3 = [A3 F3; zeros(q,q+n)];
bar_D3 = [zeros(n,q); eye(q)];
%%%%%%%%%%%

v1 = 1.0e-1;
v2 = 1.0e2;
v3 = 1.0e-1;

varepsilon11 = v1; 
varepsilon12 = v1; 
varepsilon13 = v1; 
varepsilon21 = v2;
varepsilon22 = v2; 
varepsilon23 = v2;
varepsilon31 = v3; 
varepsilon32 = v3; 
varepsilon33 = v3;

%%%%%%%%%%%%%%%%
bar_gamma1 = sdpvar(1,1);
bar_gamma2 = sdpvar(1,1);
bar_gamma3 = sdpvar(1,1);
bar_alpha1 = sdpvar(1,1);
bar_alpha2 = sdpvar(1,1);
bar_alpha3 = sdpvar(1,1);

% parameter matrix
Z1 = sdpvar(n,n);
Q1 = sdpvar(n+q,n+q);
M11 = sdpvar(m,n);
M21 = sdpvar(n+q,p);
M31 = sdpvar(n+q,p);

Z2 = sdpvar(n,n);
Q2 = sdpvar(n+q,n+q);
M12 = sdpvar(m,n);
M22 = sdpvar(n+q,p);
M32 = sdpvar(n+q,p);

Z3 = sdpvar(n,n);
Q3 = sdpvar(n+q,n+q);
M13 = sdpvar(m,n);
M23 = sdpvar(n+q,p);
M33 = sdpvar(n+q,p);

%cost function
beta1 = 1.0e-9; beta2 = 1.0e-7;% weights
obj = beta1*(bar_gamma1 + bar_gamma2 + bar_gamma3) + beta2*(bar_alpha1+bar_alpha2+bar_alpha3);

%constraints
const = [];
const = [const, bar_gamma1 >= eps, bar_gamma2 >= eps, bar_gamma3 >= eps];
const = [const, bar_alpha1 >= eps, bar_alpha2 >= eps, bar_alpha3 >= eps];
const = [const, Z1 >= eps*eye(n), Z2 >= eps*eye(n), Z3 >= eps*eye(n)];
const = [const, Q1 >= eps*eye(n+q), Q2 >= eps*eye(n+q), Q3 >= eps*eye(n+q)];

%LMI
Pi11 = blkvar;
Pi11(1,1) = (A1*Z1 - B1*M11) + (A1*Z1 - B1*M11)' + varepsilon21^(-1)*eye(n);
Pi11(2,2) = (A2*Z2 - B2*M12) + (A2*Z2 - B2*M12)' + varepsilon22^(-1)*eye(n);
Pi11(3,3) = (A3*Z3 - B3*M13) + (A3*Z3 - B3*M13)' + varepsilon23^(-1)*eye(n);
Pi11 = sdpvar(Pi11);

Pi12 = blkvar;
Pi12(1,1) = [zeros(n,n) F1];
Pi12(2,2) = [zeros(n,n) F2];
Pi12(3,3) = [zeros(n,n) F3];
Pi12 = sdpvar(Pi12);

Pi13 = blkvar;
Pi13(1,1) = B1*M11;
Pi13(2,2) = B2*M12;
Pi13(3,3) = B3*M13;
Pi13 = sdpvar(Pi13);

Z = blkvar;
Z(1,1) = Z1;
Z(2,2) = Z2;
Z(3,3) = Z3;
Z = sdpvar(Z);

Pi15 = Z*[H01 H02 H03];

Pi17 = Z*blkdiag(Cx1,Cx2,Cx3);

Pi22 = blkvar;
Pi22(1,1) = (Q1*bar_A1 - M31*bar_C1*bar_A1 - M21*bar_C1) + (Q1*bar_A1 - M31*bar_C1*bar_A1 - M21*bar_C1)';
Pi22(2,2) = (Q2*bar_A2 - M32*bar_C2*bar_A2 - M22*bar_C2) + (Q2*bar_A2 - M32*bar_C2*bar_A2 - M22*bar_C2)';
Pi22(3,3) = (Q3*bar_A3 - M33*bar_C3*bar_A3 - M23*bar_C3) + (Q3*bar_A3 - M33*bar_C3*bar_A3 - M23*bar_C3)';
Pi22 = sdpvar(Pi22);

Lambda = [eye(n); zeros(q,n)];
Pi24 = blkdiag(Lambda,Lambda,Lambda);

Pi26 = blkvar;
Pi26(1,1) = Q1 - M31*bar_C1;
Pi26(2,2) = Q2 - M32*bar_C2;
Pi26(3,3) = Q3 - M33*bar_C3;
Pi26 = sdpvar(Pi26);

Pi28 = blkdiag(Ce1, Ce2, Ce3);

Pi29 = blkvar;
Pi29(1,1) = (Q1 - M31*bar_C1)*bar_D1;
Pi29(2,2) = (Q2 - M32*bar_C2)*bar_D2;
Pi29(3,3) = (Q3 - M33*bar_C3)*bar_D3;
Pi29 = sdpvar(Pi29);

Pi33 = blkvar;
Pi33(1,1) = -varepsilon31^(-1)*Z1;
Pi33(2,2) = -varepsilon32^(-1)*Z2;
Pi33(3,3) = -varepsilon33^(-1)*Z3;
Pi33 = sdpvar(Pi33);

Pi44 = blkvar;
Pi44(1,1) = -varepsilon31*Z1;
Pi44(2,2) = -varepsilon32*Z2;
Pi44(3,3) = -varepsilon33*Z3;
Pi44 = sdpvar(Pi44);

% epsilon
epsilon1 = bar_alpha1/(varepsilon11 + varepsilon21);
epsilon2 = bar_alpha2/(varepsilon12 + varepsilon22);
epsilon3 = bar_alpha3/(varepsilon13 + varepsilon23);

Pi55 = blkvar;
Pi55(1,1) = -epsilon1*eye(h); %columns of H01
Pi55(2,2) = -epsilon2*eye(h);
Pi55(3,3) = -epsilon3*eye(h);
Pi55 = sdpvar(Pi55);


Pi66 = blkvar;
Pi66(1,1) = -varepsilon11*eye(n+q);
Pi66(2,2) = -varepsilon12*eye(n+q);
Pi66(3,3) = -varepsilon13*eye(n+q);
Pi66 = sdpvar(Pi66);


Pi99 = blkvar;
Pi99(1,1) = -bar_gamma1*eye(q); 
Pi99(2,2) = -bar_gamma2*eye(q); 
Pi99(3,3) = -bar_gamma3*eye(q); 
Pi99 = sdpvar(Pi99);

% constraint1
Pi = blkvar;
Pi(1,1) = Pi11;
Pi(1,2) = Pi12;
Pi(1,3) = Pi13;
Pi(1,5) = Pi15;
Pi(1,7) = Pi17;

Pi(2,2) = Pi22;
Pi(2,4) = Pi24;
Pi(2,6) = Pi26;
Pi(2,8) = Pi28;
Pi(2,9) = Pi29;

Pi(3,3) = Pi33;
Pi(4,4) = Pi44;
Pi(5,5) = Pi55;
Pi(6,6) = Pi66;
Pi(7,7) = -eye(3*n);
Pi(8,8) = -eye(3*(n+q));
Pi(9,9) = Pi99;

Pi = sdpvar(Pi);

const = [const, Pi <= -eps*eye(21*n+12*q+3*h)];

%solve optimization problem
ops = sdpsettings('solver', 'mosek','verbose',1);
optimize(const,obj,ops);


% results
bar_alpha1v = value(bar_alpha1)
bar_alpha2v = value(bar_alpha2)
bar_alpha3v = value(bar_alpha3)

bar_gamma1v = value(bar_gamma1)
bar_gamma2v = value(bar_gamma2)
bar_gamma3v = value(bar_gamma3)

Z10 = value(Z1);
Z20 = value(Z2);
Z30 = value(Z3);

Q10 = value(Q1);
Q20 = value(Q2);
Q30 = value(Q3);

M110 = value(M11);
M120 = value(M12);
M130 = value(M13);

M210 = value(M21);
M220 = value(M22);
M230 = value(M23);

M310 = value(M31);
M320 = value(M32);
M330 = value(M33);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Kx1 =M110*inv(Z10);
L11 = inv(Q10)*M210;
H1 = inv(Q10)*M310;

N1 = eye(n+q) - H1*bar_C1;
G1 = N1*bar_B1;
M1 = N1*bar_A1 - L11*bar_C1;
L12 = M1*H1;
L1 = L11 + L12;
%%%%%%%%%%%%%%%%%%%%%%%%%%%
Kx2 =M120*inv(Z20);
L21 = inv(Q20)*M220;
H2 = inv(Q20)*M320;

N2 = eye(n+q) - H2*bar_C2;
G2 = N2*bar_B2;
M2 = N2*bar_A2 - L21*bar_C2;
L22 = M2*H2;
L2 = L21 + L22;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
Kx3 =M130*inv(Z30);
L31 = inv(Q30)*M230;
H3 = inv(Q30)*M330;

N3 = eye(n+q) - H3*bar_C3;
G3 = N3*bar_B3;
M3 = N3*bar_A3 - L31*bar_C3;
L32 = M3*H3;
L3 = L31 + L32;

Kf1 = pinv(B1)*F1;
Kf2 = pinv(B2)*F2;
Kf3 = pinv(B3)*F3;
